#version 430

layout(binding=0) uniform sampler2D texPotCenters;
layout(binding=1) uniform sampler2D texPot;
layout(binding=2) uniform sampler2D texSurfNormals;

in vec3 posV[];
in vec2 uvV[];

out vec4 posG;
out vec2 uvG;
out float perG;
out vec3 normG;

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}
vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}
vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}
vec3 rotateYZ3(vec3 p, float a) {
  return rotateYZ(vec4(p, 0.0), a).xyz;
}
vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}


layout(points) in;
layout(triangle_strip, max_vertices = 18) out;
//layout(line_strip, max_vertices = 15) out;


layout(binding=0, offset=0) uniform atomic_uint ac;

 
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;
layout(binding=2) uniform sampler2D texEmit;

uniform float g_pikselos = 0.0;

uniform float g_partSize = 0.15;


float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}

uniform float surfGridRes2D;

// 3D grid size which is the same for width, height & depth
uniform float surfGridDim3D;

// 1.0 scale puts the surfGrid to xyz coords varying from
// -surfGridDim3D*0.5 to surfGridDim3D*0.5
uniform float surfGridScale = 1.0;

// ivec2 ts = textureSize(s, 0);
// return texelFetch(s, ivec2(c.x*ts.x, c.y*ts.y), 0);


// gl_FragCoord.x

vec3 getPos3D(vec2 tp) {
    tp = floor(tp);
    float kb = surfGridRes2D/surfGridDim3D; // 10 for example when dim3d is 100 and res2d is 1000
    vec3 pos3D = vec3(0.0);
    vec2 osa = tp/surfGridDim3D;
    vec2 cellXY = fract(osa)*surfGridDim3D;
    vec2 cellZ = floor(osa);
    float indZ = cellZ.x+cellZ.y*kb;
    pos3D = vec3(cellXY, indZ);
    return pos3D;
}

vec2 getPos2D(vec3 pos3D) {
    vec2 res;
    pos3D = floor(pos3D);
    float kb = surfGridRes2D/(surfGridDim3D); // 10 for example when dim3d is 100 and res2d is 1000
    res.xy = fract(pos3D.xy/(surfGridDim3D))*(surfGridDim3D);
    float osa = (pos3D.z)/kb;
    res.x += fract(osa)*(surfGridRes2D);
    res.y += floor(osa)*(surfGridDim3D);
   // res = floor(res);
    return res;
}

vec4 texture2D_(sampler2D s, vec2 p) {
  // return texelFetch(s, ivec2(p.x+0.0, p.y+0.0), 0);
  return texture2D(s, p/surfGridRes2D);
}



void main(void) {
    if (gl_in.length()<1) {
        return;
    }

    if (gl_in.length()>1) {
        return;
    }

    mat4 mvp = projectionMatrix * modelViewMatrix;

    if (posV[0].z > surfGridDim3D-1.0) {
        return;
    }

    vec3 posP = (posV[0]+vec3(0.5));

    vec2 pos2D = getPos2D(posP);

    vec4 pos = vec4(posV[0]-vec3(surfGridDim3D)*0.5, 1.0);
    // pos.xyz *= 0.5;
    vec4 pW = mvp*pos;

    vec2 munUv = uvV[0];
    int primID = gl_PrimitiveIDIn;

    gl_PrimitiveID = gl_PrimitiveIDIn;

    vec4 pot = texture2D_(texPotCenters, pos2D);

    if (pot.x < 0.0) {
   //   return;
    }

    perG = 1.0;

    normG = vec3(0.0);

    vec4 pv = texture2D_(texPot, pos2D);

    // float dg = 0.1;

    float de = 1.0;

    vec2 p_x = getPos2D(posP+vec3(de, 0.0, 0.0));
    vec4 pot_x = texture2D_(texPotCenters, p_x);
    vec4 pv_x = texture2D_(texPot, p_x);

    vec2 p_y = getPos2D(posP+vec3(0.0, de, 0.0));
    vec4 pot_y = texture2D_(texPotCenters, p_y);
    vec4 pv_y = texture2D_(texPot, p_y);

    vec2 p_z = getPos2D(posP+vec3(0.0, 0.0, de));
    vec4 pot_z = texture2D_(texPotCenters, p_z);
    vec4 pv_z = texture2D_(texPot, p_z);

    vec2 p_xy = getPos2D(posP+vec3(de, de, 0.0));
    vec4 pot_xy = texture2D_(texPotCenters, p_xy);

    vec2 p_yz = getPos2D(posP+vec3(0.0, de, de));
    vec4 pot_yz = texture2D_(texPotCenters, p_yz);

    vec2 p_xz = getPos2D(posP+vec3(de, 0.0, de));
    vec4 pot_xz = texture2D_(texPotCenters, p_xz);

    float d = 0.0;
    float km = 1.0;
    float bs = surfGridScale*1.0;


    if ((pot.x>-1.0 && pot_x.x>-1.0 && pot_y.x>-1.0)) { //  && pot_xy.x>=-0.5)) {
   // if (((pot.x>=0.0 || pot.y>=0.0 || pot.z>=0.0) &&
   //      (pot_x.x>=0.0 || pot_x.y>=0.0 || pot_x.z>=0) &&
   //      (pot_y.x>=0 || pot_y.y>=0 || pot_y.z>=0) &&
    //     (pot_xy.x>=0 || pot_xy.y>=0 || pot_xy.z>=0))) {
       // normG = normalize(vec3(pv_x.r-pv.r, pv_y.r-pv.r, pv_z.r-pv.r));
       normG = texture2D_(texSurfNormals, pos2D).rgb;
      //  normG = vec3(0.0, 0.0, 1.0);
        gl_Position = mvp*(pos+vec4(0.0, 0.0, 0.0, 0.0)+km*vec4(pot.xyz, 0.0));
        posG = gl_Position;
        uvG = vec2(0.0, 0.0);
        EmitVertex();
        //normG = normalize(vec3(pv_x_x.r-pv_x.r, pv_x_y.r-pv_x.r, pv_x_z.r-pv_x.r));
        normG = texture2D_(texSurfNormals, p_x).rgb;
        gl_Position = mvp*(pos+vec4(bs, 0.0, 0.0, 0.0)+km*vec4(pot_x.xyz, 0.0));
        posG = gl_Position;
        uvG = vec2(1.0, 0.0);
        EmitVertex();
        //normG = normalize(vec3(pv_y_x.r-pv_y.r, pv_y_y.r-pv_y.r, pv_y_z.r-pv_y.r));
        normG = texture2D_(texSurfNormals, p_y).rgb;
        gl_Position = mvp*(pos+vec4(0.0, bs, 0.0, 0.0)+km*vec4(pot_y.xyz, 0.0));
        posG = gl_Position;
        uvG = vec2(0.0, 1.0);
        EmitVertex();
        //normG = normalize(vec3(pv_z_x.r-pv_z.r, pv_z_y.r-pv_z.r, pv_z_z.r-pv_z.r));
        normG = texture2D_(texSurfNormals, p_xy).rgb;
        if (pot_xy.x > -1.0) {
            gl_Position = mvp*(pos+vec4(bs, bs, 0.0, 0.0)+km*vec4(pot_xy.xyz, 0.0));
            posG = gl_Position;
            uvG = vec2(1.0, 1.0);
            EmitVertex();
        }
        EndPrimitive();
    }

    if ((pot.x>-1.0 && pot_y.x>-1.0 && pot_z.x>-1.0)) { // && pot_yz.x>=-0.50)) {
      //  normG = normalize(vec3(pv_x.r-pv.r, pv_y.r-pv.r, pv_z.r-pv.r));
     //   normG = vec3(1.0, 0.0, 0.0);
     normG = texture2D_(texSurfNormals, pos2D).rgb;
        gl_Position = mvp*(pos+vec4(0.0, 0.0, 0.0, 0.0)+km*vec4(pot.xyz, 0.0));
        posG = gl_Position;
        uvG = vec2(0.0, 0.0);
        EmitVertex();
        normG = texture2D_(texSurfNormals, p_y).rgb;
        gl_Position = mvp*(pos+vec4(0.0, bs, 0.0, 0.0)+km*vec4(pot_y.xyz, 0.0));
        posG = gl_Position;
        uvG = vec2(1.0, 0.0);
        EmitVertex();
        normG = texture2D_(texSurfNormals, p_z).rgb;
        gl_Position = mvp*(pos+vec4(0.0, 0.0, bs, 0.0)+km*vec4(pot_z.xyz, 0.0));
        posG = gl_Position;
        uvG = vec2(0.0, 1.0);
        EmitVertex();
        if (pot_yz.x > -1.0) {
            normG = texture2D_(texSurfNormals, p_yz).rgb;
            gl_Position = mvp*(pos+vec4(0.0, bs, bs, 0.0)+km*vec4(pot_yz.xyz, 0.0));
            posG = gl_Position;
            uvG = vec2(1.0, 1.0);
            EmitVertex();
        }
        EndPrimitive();
    }


    if (((pot.x>-1.0) && pot_x.x>-1.0 && pot_z.x>-1.0)) { // && pot_xz.x>=-0.50)) {
        //normG = normalize(vec3(pv_x.r-pv.r, pv_y.r-pv.r, pv_z.r-pv.r));
     //   normG = vec3(0.0, 1.0, 0.0);
     normG = texture2D_(texSurfNormals, pos2D).rgb;
        gl_Position = mvp*(pos+vec4(0.0, 0.0, 0.0, 0.0)+km*vec4(pot.xyz, 0.0));
        posG = gl_Position;
        uvG = vec2(0.0, 0.0);
        EmitVertex();
        normG = texture2D_(texSurfNormals, p_x).rgb;
        gl_Position = mvp*(pos+vec4(bs, 0.0, 0.0, 0.0)+km*vec4(pot_x.xyz, 0.0));
        posG = gl_Position;
        uvG = vec2(1.0, 0.0);
        EmitVertex();
        normG = texture2D_(texSurfNormals, p_z).rgb;
        gl_Position = mvp*(pos+vec4(0.0, 0.0, bs, 0.0)+km*vec4(pot_z.xyz, 0.0));
        posG = gl_Position;
        uvG = vec2(0.0, 1.0);
        EmitVertex();
        if (pot_xz.x > -1.0) {
            normG = texture2D_(texSurfNormals, p_xz).rgb;
            gl_Position = mvp*(pos+vec4(bs, 0.0, bs, 0.0)+km*vec4(pot_xz.xyz, 0.0));
            posG = gl_Position;
            uvG = vec2(1.0, 1.0);
            EmitVertex();
        }
        EndPrimitive();
    }

/*
        float per = clamp(0.50-abs(pv.r), 0.0, 0.50)*2.0;

        per = pow(per,8.0)*3.0;

        float pSize = 0.2*per;

        if (pSize < 0.001) {
          return;
        }

      //  pSize = 0.1;

        float sizeX = pSize;
        float sizeY = pSize;
        float rotAngle = 0.0;
        float ar = 1.0;
        vec4 k;

        perG = pow(per, 1.0);

        normG = vec3(0.0, 1.0, 0.0);
        k = rotateXY(vec4(-sizeX, -sizeY, 0.0, 0.0), rotAngle);
        gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
        posG = gl_Position;
        uvG = vec2(0.0, 0.0);
        EmitVertex();

        k = rotateXY(vec4(sizeX, -sizeY, 0.0, 0.0), rotAngle);
        gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
        posG = gl_Position;
        uvG = vec2(1.0, 0.0);
        EmitVertex();

        k = rotateXY(vec4(-sizeX, sizeY, 0.0, 0.0), rotAngle);
        gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
        posG = gl_Position;
        uvG = vec2(0.0, 1.0);
        EmitVertex();


        k = rotateXY(vec4(sizeX, sizeY, 0.0, 0.0), rotAngle);
        gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
        posG = gl_Position;
        uvG = vec2(1.0, 1.0);
        EmitVertex();

        EndPrimitive();
*/
/*
    float per = 1.0;
    float pSize = 0.2;
    if (pot.r < 0.0) {
      return;
    }

    //  pSize = 0.1;

    float sizeX = pSize;
    float sizeY = pSize;
    float rotAngle = 0.0;
    float ar = 1.0;
    vec4 k;

    perG = pow(per, 1.0);

    normG = vec3(0.0, 1.0, 0.0);
    k = rotateXY(vec4(-sizeX, -sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(0.0, 0.0);
    EmitVertex();

    k = rotateXY(vec4(sizeX, -sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(1.0, 0.0);
    EmitVertex();

    k = rotateXY(vec4(-sizeX, sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(0.0, 1.0);
    EmitVertex();


    k = rotateXY(vec4(sizeX, sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(1.0, 1.0);
    EmitVertex();

    EndPrimitive();
    */
}
